<?php
use yii\helpers\Html;

$this->title = 'Номера и цены';
?>

<h1><?= Html::encode($this->title) ?></h1>

<div class="row">
    <?php foreach($rooms as $room): ?>
        <div class="col-md-4">
            <div class="card mb-3">
                <?= Html::img('@web/images/'.$room->image, ['class'=>'card-img-top','alt'=>$room->name]) ?>
                <div class="card-body">
                    <h5 class="card-title"><?= Html::encode($room->name) ?></h5>
                    <p class="card-text"><?= Html::encode($room->description) ?></p>
                    <p class="card-text"><strong>Цена:</strong> <?= Html::encode($room->price) ?> ₽</p>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>
