<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация';
?>

<div class="auth-container">
    <div class="row justify-content-center align-items-center min-vh-100 py-5">
        <div class="col-lg-6 col-md-8 col-sm-10">
            <div class="auth-card card border-0 shadow-lg rounded-3 overflow-hidden">
                <div class="card-body p-5">
                    <!-- Заголовок -->
                    <div class="text-center mb-5">
                        <div class="auth-icon bg-success bg-opacity-10 rounded-circle p-3 d-inline-flex mb-4">
                            <i class="fas fa-user-plus fa-2x text-success"></i>
                        </div>
                        <h1 class="h2 fw-bold text-success mb-2"><?= Html::encode($this->title) ?></h1>
                        <p class="text-muted">Создайте аккаунт для бронирования номеров</p>
                    </div>

                    <?php $form = ActiveForm::begin([
                        'options' => ['class' => 'auth-form'],
                        'fieldConfig' => [
                            'options' => ['class' => 'form-group mb-4'],
                            'template' => "{label}\n{input}\n{error}",
                            'inputOptions' => ['class' => 'form-control form-control-lg py-3'],
                            'errorOptions' => ['class' => 'invalid-feedback'],
                            'labelOptions' => ['class' => 'form-label fw-medium text-dark mb-2']
                        ]
                    ]); ?>

                    <!-- Поле ФИО -->
                    <div class="form-floating mb-4">
                        <?= $form->field($model, 'fio')->textInput([
                            'placeholder' => 'Иванов Иван Иванович',
                            'class' => 'form-control form-control-lg py-3'
                        ])->label('ФИО') ?>
                        <div class="form-text">Введите ваше полное имя</div>
                    </div>

                    <!-- Поле email -->
                    <div class="form-floating mb-4">
                        <?= $form->field($model, 'email')->textInput([
                            'placeholder' => 'name@example.com',
                            'class' => 'form-control form-control-lg py-3'
                        ])->label('Email адрес') ?>
                        <div class="form-text">На этот email придет подтверждение</div>
                    </div>

                    <!-- Двухколоночный ряд для телефона и паспорта -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <?= $form->field($model, 'phone')->textInput([
                                    'placeholder' => '+7 (999) 999-99-99',
                                    'class' => 'form-control form-control-lg py-3'
                                ])->label('Телефон') ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <?= $form->field($model, 'passport')->textInput([
                                    'placeholder' => 'Серия и номер',
                                    'class' => 'form-control form-control-lg py-3'
                                ])->label('Паспорт') ?>
                            </div>
                        </div>
                    </div>

                    <!-- Двухколоночный ряд для паролей -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <?= $form->field($model, 'password')->passwordInput([
                                    'placeholder' => 'Создайте пароль',
                                    'class' => 'form-control form-control-lg py-3'
                                ])->label('Пароль') ?>
                                <div class="form-text">Минимум 6 символов</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <?= $form->field($model, 'password_repeat')->passwordInput([
                                    'placeholder' => 'Повторите пароль',
                                    'class' => 'form-control form-control-lg py-3'
                                ])->label('Подтверждение пароля') ?>
                            </div>
                        </div>
                    </div>

                    <!-- Соглашение -->
                    <div class="form-check mb-4">
                        <input class="form-check-input" type="checkbox" id="agreeTerms" required>
                        <label class="form-check-label text-muted small" for="agreeTerms">
                            Я соглашаюсь с <a href="#" class="text-success text-decoration-none">правилами обработки персональных данных</a> и <a href="#" class="text-success text-decoration-none">пользовательским соглашением</a>
                        </label>
                    </div>

                    <!-- Кнопка регистрации -->
                    <div class="form-group mb-4">
                        <?= Html::submitButton('Зарегистрироваться', [
                            'class' => 'btn btn-success btn-lg w-100 py-3 fw-bold fs-5',
                            'name' => 'register-button'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                    <!-- Разделитель -->
                    <div class="text-center mb-4">
                        <div class="divider d-flex align-items-center">
                            <span class="flex-grow-1 border-top"></span>
                            <span class="mx-3 text-muted small">Уже есть аккаунт?</span>
                            <span class="flex-grow-1 border-top"></span>
                        </div>
                    </div>

                    <!-- Ссылка на вход -->
                    <div class="text-center">
                        <a href="/site/login" class="btn btn-outline-success btn-lg px-4">
                            <i class="fas fa-sign-in-alt me-2"></i>Войти в аккаунт
                        </a>
                    </div>
                </div>

                <!-- Декоративный элемент внизу -->
                <div class="card-footer bg-transparent border-0 py-4">
                    <div class="text-center">
                        <small class="text-muted">
                            <i class="fas fa-lock me-1"></i>
                            Все данные защищены и передаются по безопасному соединению
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Дополнительные стили -->
<style>
    .auth-container {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        min-height: 100vh;
        padding: 20px 0;
    }

    .auth-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
    }

    .auth-icon {
        transition: transform 0.3s ease;
    }

    .auth-card:hover .auth-icon {
        transform: scale(1.1);
    }

    .form-control {
        border: 2px solid #e9ecef;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: #28a745;
        box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
    }

    .btn-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        border: none;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(40, 167, 69, 0.4);
    }

    .btn-outline-success {
        border: 2px solid #28a745;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .btn-outline-success:hover {
        background-color: #28a745;
        border-color: #28a745;
        transform: translateY(-2px);
    }

    .divider {
        color: #6c757d;
    }

    .form-text {
        font-size: 0.875rem;
        color: #6c757d;
        margin-top: 0.25rem;
    }

    .auth-form .invalid-feedback {
        display: block;
        margin-top: 0.5rem;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .auth-card .card-body {
            padding: 2rem 1.5rem;
        }

        .form-control-lg {
            font-size: 1rem;
            padding: 1rem 1.25rem;
        }

        .row.g-3 .col-md-6 {
            margin-bottom: 1rem;
        }
    }

    /* Анимация появления */
    .auth-card {
        animation: slideUp 0.5s ease-out;
    }

    @keyframes slideUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>