<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Вход';
?>

<div class="auth-container">
    <div class="row justify-content-center align-items-center min-vh-100">
        <div class="col-lg-5 col-md-7 col-sm-9">
            <div class="auth-card card border-0 shadow-lg rounded-3 overflow-hidden">
                <div class="card-body p-5">
                    <!-- Заголовок -->
                    <div class="text-center mb-5">
                        <div class="auth-icon bg-primary bg-opacity-10 rounded-circle p-3 d-inline-flex mb-4">
                            <i class="fas fa-sign-in-alt fa-2x text-primary"></i>
                        </div>
                        <h1 class="h2 fw-bold text-primary mb-2"><?= Html::encode($this->title) ?></h1>
                        <p class="text-muted">Войдите в свой аккаунт для продолжения</p>
                    </div>

                    <?php $form = ActiveForm::begin([
                        'options' => ['class' => 'auth-form'],
                        'fieldConfig' => [
                            'options' => ['class' => 'form-group mb-4'],
                            'template' => "{label}\n{input}\n{error}",
                            'inputOptions' => ['class' => 'form-control form-control-lg py-3'],
                            'errorOptions' => ['class' => 'invalid-feedback'],
                            'labelOptions' => ['class' => 'form-label fw-medium text-dark mb-2']
                        ]
                    ]); ?>

                    <!-- Поле email -->
                    <div class="form-floating mb-4">
                        <?= $form->field($model, 'email')->textInput([
                            'placeholder' => 'name@example.com',
                            'class' => 'form-control form-control-lg py-3'
                        ])->label('Email адрес') ?>
                    </div>

                    <!-- Поле пароля -->
                    <div class="form-floating mb-4">
                        <?= $form->field($model, 'password')->passwordInput([
                            'placeholder' => 'Введите ваш пароль',
                            'class' => 'form-control form-control-lg py-3'
                        ])->label('Пароль') ?>
                    </div>

                    <!-- Дополнительные опции -->
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="rememberMe">
                            <label class="form-check-label text-muted small" for="rememberMe">
                                Запомнить меня
                            </label>
                        </div>
                        <a href="#" class="text-primary text-decoration-none small fw-medium">
                            Забыли пароль?
                        </a>
                    </div>

                    <!-- Кнопка входа -->
                    <div class="form-group mb-4">
                        <?= Html::submitButton('Войти', [
                            'class' => 'btn btn-primary btn-lg w-100 py-3 fw-bold fs-5',
                            'name' => 'login-button'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                    <!-- Разделитель -->
                    <div class="text-center mb-4">
                        <div class="divider d-flex align-items-center">
                            <span class="flex-grow-1 border-top"></span>
                            <span class="mx-3 text-muted small">или</span>
                            <span class="flex-grow-1 border-top"></span>
                        </div>
                    </div>

                    <!-- Ссылка на регистрацию -->
                    <div class="text-center">
                        <p class="text-muted mb-0">
                            Еще нет аккаунта?
                            <a href="/site/register" class="text-primary text-decoration-none fw-medium">
                                Зарегистрироваться
                            </a>
                        </p>
                    </div>
                </div>

                <!-- Декоративный элемент внизу -->
                <div class="card-footer bg-transparent border-0 py-4">
                    <div class="text-center">
                        <small class="text-muted">
                            <i class="fas fa-shield-alt me-1"></i>
                            Ваши данные защищены
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Дополнительные стили -->
<style>
    .auth-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        padding: 20px 0;
    }

    .auth-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
    }

    .auth-icon {
        transition: transform 0.3s ease;
    }

    .auth-card:hover .auth-icon {
        transform: scale(1.1);
    }

    .form-control {
        border: 2px solid #e9ecef;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }

    .btn-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
    }

    .divider {
        color: #6c757d;
    }

    .auth-form .invalid-feedback {
        display: block;
        margin-top: 0.5rem;
    }

    /* Адаптивность */
    @media (max-width: 576px) {
        .auth-card .card-body {
            padding: 2rem 1.5rem;
        }

        .form-control-lg {
            font-size: 1rem;
            padding: 1rem 1.25rem;
        }
    }
</style>