<?php
/** @var yii\web\View $this */
use yii\helpers\Html;

$this->title = 'My Yii Application';
$this->registerCss(<<<CSS
/* ===== ГЛОБАЛЬНЫЕ СТИЛИ ===== */
:root {
    --primary: #667eea;
    --secondary: #764ba2;
    --light: #f8f9fa;
    --dark: #212529;
    --transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
}

body {
    font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
    overflow-x: hidden;
}

.transition-all { transition: var(--transition); }

/* ===== HERO SECTION ===== */
.hero-section {
    overflow: hidden;
}
.hero-banner {
    height: 100vh;
    min-height: 600px;
    display: flex;
    align-items: center;
}
.hero-overlay {
    position: absolute;
    top: 0; left: 0; right: 0; bottom: 0;
}
.hero-content {
    animation: fadeInUp 1s ease-out;
}
.hero-badge .badge {
    letter-spacing: 0.5px;
}
.hero-title i {
    animation: pulse 2s infinite;
}
@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* ===== FEATURE CARDS ===== */
.feature-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 30px rgba(0,0,0,0.12);
}
.icon-wrapper {
    transition: var(--transition);
}
.feature-card:hover .icon-wrapper {
    background-color: var(--primary);
    transform: scale(1.1);
}
.feature-card:hover .icon-wrapper i {
    color: white;
}

/* ===== TESTIMONIALS ===== */
.testimonial-card {
    border: 1px solid rgba(0,0,0,0.05);
    transition: var(--transition);
}
.testimonial-card:hover {
    transform: scale(1.03);
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
}

/* ===== ROOM CARDS ===== */
.room-card {
    border-radius: 16px !important;
    overflow: hidden;
}
.room-img {
    transition: transform 0.5s ease;
}
.room-card:hover .room-img {
    transform: scale(1.05);
}
.room-overlay {
    opacity: 0;
}
.room-card:hover .room-overlay {
    background-color: rgba(0,0,0,0.5);
    opacity: 1;
}
.room-card:hover .room-overlay button {
    opacity: 1;
    transform: translateY(0);
}
.room-overlay button {
    transform: translateY(20px);
}

/* ===== CTA SECTION ===== */
.cta-section {
    background: linear-gradient(135deg, var(--primary), var(--secondary));
    position: relative;
    overflow: hidden;
}
.cta-section::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    z-index: 0;
}
.cta-section .container {
    position: relative;
    z-index: 2;
}

/* ===== CONTACT INFO ===== */
.contact-info:hover .contact-icon {
    transform: scale(1.2) rotate(10deg);
    background-color: var(--primary);
}
.contact-icon i {
    transition: var(--transition);
}
.contact-info:hover .contact-icon i {
    color: white;
}

/* ===== ГЛАВНАЯ КНОПКА ===== */
.btn-primary {
    background-color: var(--primary);
    border-color: var(--primary);
}
.btn-primary:hover {
    background-color: #5a6fd8;
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(102, 126, 234, 0.4);
}
.btn-outline-light:hover {
    background-color: rgba(255,255,255,0.9);
    transform: translateY(-2px);
}

/* ===== RESPONSIVE FIXES ===== */
@media (max-width: 768px) {
    .hero-title { font-size: 2.5rem !important; }
    .hero-subtitle { font-size: 1.25rem !important; }
    .stat-item { margin-bottom: 1rem; }
    .hero-actions a { display: block; width: 100%; margin: 0.5rem 0 !important; }
    .feature-card, .testimonial-card { margin-bottom: 1rem; }
}
CSS
);
?>

<!-- Подключим Font Awesome (если ещё не подключён) -->
<?php $this->registerJsFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/js/all.min.js', [
    'depends' => [\yii\web\JqueryAsset::class]
]); ?>

<!-- Hero Section -->
<section class="hero-section">
    <div class="container-fluid px-0">
        <div class="hero-banner position-relative">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-3">
                <div class="row justify-content-center text-center py-8">
                    <div class="col-lg-8 col-md-10">
                        <div class="hero-content text-white">
                            <div class="hero-badge mb-4">
                                <span class="badge bg-light text-primary px-4 py-2 rounded-pill fs-6">
                                    <i class="fas fa-trophy me-2"></i>Лучший отель 2025
                                </span>
                            </div>
                            <h1 class="hero-title display-3 fw-bold mb-4">
                                <i class="fas fa-home me-3"></i>Как дома!
                            </h1>
                            <p class="hero-subtitle lead mb-5">
                                Комфортный отель с уютными номерами, ресторанами и спа-зоной. Мы создаём атмосферу домашнего уюта для каждого гостя.
                            </p>
                            <div class="hero-stats row justify-content-center mb-5">
                                <div class="col-auto">
                                    <div class="stat-item">
                                        <div class="stat-number h3 fw-bold text-white">50+</div>
                                        <div class="stat-label text-light">Номеров</div>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="stat-item">
                                        <div class="stat-number h3 fw-bold text-white">4.9</div>
                                        <div class="stat-label text-light">Рейтинг</div>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="stat-item">
                                        <div class="stat-number h3 fw-bold text-white">1000+</div>
                                        <div class="stat-label text-light">Гостей</div>
                                    </div>
                                </div>
                            </div>
                            <div class="hero-actions">
                                <a href="#rooms" class="btn btn-primary btn-lg me-3 px-4 py-2">
                                    <i class="fas fa-eye me-2"></i>Посмотреть номера
                                </a>
                                <a href="/site/rooms" class="btn btn-outline-light btn-lg px-4 py-2">
                                    <i class="fas fa-calendar-check me-2"></i>Забронировать
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features -->
<section class="features-section py-6 bg-light">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-12 text-center">
                <h2 class="section-title h1 fw-bold mb-3">Почему выбирают нас</h2>
                <p class="section-subtitle text-muted lead">Мы заботимся о вашем комфорте на каждом этапе</p>
            </div>
        </div>
        <div class="row justify-content-center g-4">
            <?php foreach([['wifi', 'Бесплатный Wi-Fi', 'Высокоскоростной интернет во всех номерах и общественных зонах отеля для комфортного пребывания.'], 
                           ['utensils', 'Ресторан', 'Вкусная кухня от наших шеф-поваров. Завтраки включены в стоимость проживания.'],
                           ['spa', 'СПА-зона', 'Расслабляющие процедуры, бассейн и сауна для полного восстановления сил.'],
                           ['parking', 'Парковка', 'Охраняемая парковка для гостей отеля. Доступна круглосуточно без дополнительной платы.']] as $f): ?>
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card text-center p-4 bg-white rounded-3 shadow-sm h-100">
                        <div class="feature-icon mb-3">
                            <div class="icon-wrapper rounded-circle p-3 d-inline-flex">
                                <i class="fas fa-<?= $f[0] ?> fa-2x text-primary"></i>
                            </div>
                        </div>
                        <h3 class="h4 mb-3"><?= $f[1] ?></h3>
                        <p class="text-muted mb-0"><?= $f[2] ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Testimonials -->
<section class="testimonials-section py-6 bg-white">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-12 text-center">
                <h2 class="section-title h1 fw-bold mb-3">Отзывы наших гостей</h2>
                <p class="section-subtitle text-muted lead">Что говорят о нас путешественники</p>
            </div>
        </div>
        <div class="row justify-content-center g-4">
            <?php foreach([['Анна Петрова', 5, '"Прекрасный отель с уютной атмосферой. Персонал очень внимательный, номера чистые и комфортные. Обязательно вернёмся!"'],
                           ['Иван Сидоров', 4.5, '"Отличное расположение, вкусные завтраки и комфортные кровати. СПА-зона просто великолепна после долгого дня."'],
                           ['Мария Козлова', 5, '"Останавливались семьёй с детьми. Дети в восторге от бассейна, а мы — от уровня сервиса. Рекомендуем всем!"']] as $t): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="testimonial-card p-4 bg-light rounded-3 h-100">
                        <div class="testimonial-header d-flex align-items-center justify-content-center mb-3">
                            <div class="avatar bg-primary rounded-circle me-3" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-user text-white fs-5"></i>
                            </div>
                            <div class="text-start">
                                <h5 class="mb-1"><?= $t[0] ?></h5>
                                <div class="stars text-warning">
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <i class="fas <?= $i <= floor($t[1]) ? 'fa-star' : ($i - 0.5 <= $t[1] ? 'fa-star-half-alt' : 'far fa-star') ?>"></i>
                                    <?php endfor; ?>
                                </div>
                            </div>
                        </div>
                        <p class="text-muted mb-0"><?= $t[2] ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Rooms -->
<section id="rooms" class="rooms-section py-6 bg-light">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-12 text-center">
                <h2 class="section-title h1 fw-bold mb-3">Наши номера</h2>
                <p class="section-subtitle text-muted lead">Выберите идеальный номер для вашего отдыха</p>
            </div>
        </div>
        <div class="row justify-content-center g-4">
            <?php foreach($rooms as $room): ?>
                <div class="col-xl-4 col-lg-6">
                    <div class="room-card card border-0 shadow-sm h-100">
                        <div class="room-image position-relative overflow-hidden">
                            <?= Html::img('@web/images/'.$room->image, [
                                'class' => 'card-img-top room-img w-100',
                                'alt' => Html::encode($room->name),
                                'style' => 'height: 250px; object-fit: cover;'
                            ]) ?>
                            <div class="room-price position-absolute top-0 end-0 m-3">
                                <span class="price-badge bg-primary text-white px-3 py-2 rounded-pill fw-bold fs-6">
                                    <?= number_format($room->price, 0, '', ' ') ?> ₽ <small class="opacity-75">/ сутки</small>
                                </span>
                            </div>
                            <div class="room-overlay">
                                <button class="btn btn-light rounded-pill px-4">
                                    <i class="fas fa-expand me-2"></i>Быстрый просмотр
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-4">
                            <h4 class="room-name h5 fw-bold mb-3"><?= Html::encode($room->name) ?></h4>
                            <p class="room-description text-muted mb-3"><?= Html::encode($room->description) ?></p>
                            <div class="room-features mb-4">
                                <div class="row g-2 text-muted small">
                                    <div class="col-6"><i class="fas fa-user-friends me-1"></i> До 2 гостей</div>
                                    <div class="col-6"><i class="fas fa-ruler-combined me-1"></i> <?= $room->area ?? '25' ?> м²</div>
                                    <div class="col-6"><i class="fas fa-wifi me-1"></i> Wi-Fi</div>
                                    <div class="col-6"><i class="fas fa-tv me-1"></i> Телевизор</div>
                                </div>
                            </div>
                            <div class="room-actions">
                                <a href="/site/rooms" class="btn btn-primary w-100 py-2">
                                    <i class="fas fa-calendar-check me-2"></i>Забронировать
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- CTA -->
<section class="cta-section py-6">
    <div class="container">
        <div class="row justify-content-center text-center">
            <div class="col-lg-8">
                <h3 class="h2 fw-bold mb-3">Готовы к незабываемому отдыху?</h3>
                <p class="lead mb-4 opacity-90">
                    Забронируйте номер прямо сейчас и получите <strong class="text-warning">скидку 15%</strong> для новых гостей!
                </p>
                <a href="/site/rooms" class="btn btn-light btn-lg px-5 py-3 fw-bold shadow-lg">
                    <i class="fas fa-gift me-2"></i>Забронировать со скидкой
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Contact -->
<section class="contact-section py-6 bg-white">
    <div class="container">
        <div class="row justify-content-center g-4">
            <?php foreach([['map-marker-alt', 'Адрес', 'г. Москва, ул. Примерная, д. 123'],
                           ['phone', 'Телефон', '+7 (495) 123-45-67'],
                           ['envelope', 'Email', 'info@kakdoma.ru']] as $c): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="contact-info">
                        <div class="contact-icon rounded-circle p-3 d-inline-flex mb-3">
                            <i class="fas fa-<?= $c[0] ?> fa-2x text-primary"></i>
                        </div>
                        <h5 class="fw-bold mb-2"><?= $c[1] ?></h5>
                        <p class="text-muted mb-0"><?= $c[2] ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Smooth scroll -->
<?php $this->registerJs(<<<JS
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function(e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            window.scrollTo({
                top: target.offsetTop - 80,
                behavior: 'smooth'
            });
        }
    });
});
JS
); ?>