<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-100">
    <head>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
    </head>
    <body class="d-flex flex-column h-100">
    <?php $this->beginBody() ?>

    <?php
    NavBar::begin([
        'brandLabel' => '<i class="fas fa-home me-2"></i>Как дома',
        'brandUrl' => Yii::$app->homeUrl,
        'options' => ['class' => 'navbar navbar-expand-lg navbar-light bg-white fixed-top shadow-sm'],
        'brandOptions' => ['class' => 'navbar-brand fw-bold text-primary fs-3'],
    ]);

    $centerItems = [
        ['label' => '<i class="fas fa-home me-1"></i>Главная', 'url' => ['/site/index'], 'encode' => false],
        ['label' => '<i class="fas fa-bed me-1"></i>Номера и цены', 'url' => ['/site/rooms'], 'encode' => false],
    ];

    $rightItems = [];

    if (Yii::$app->user->isGuest) {
        $rightItems[] = ['label' => '<i class="fas fa-user-plus me-1"></i>Регистрация', 'url' => ['/site/register'], 'encode' => false, 'linkOptions' => ['class' => 'btn btn-outline-primary me-2']];
        $rightItems[] = ['label' => '<i class="fas fa-sign-in-alt me-1"></i>Вход', 'url' => ['/site/login'], 'encode' => false, 'linkOptions' => ['class' => 'btn btn-primary']];
    } else {
        $centerItems[] = ['label' => '<i class="fas fa-calendar-check me-1"></i>Мои бронирования', 'url' => ['/booking/index'], 'encode' => false];
        if (Yii::$app->user->identity->is_admin) {
            $centerItems[] = ['label' => '<i class="fas fa-cog me-1"></i>Панель админа', 'url' => ['/admin/index'], 'encode' => false];
        }
        $rightItems[] = '<li class="nav-item dropdown">'
            . Html::beginTag('a', ['class' => 'nav-link dropdown-toggle text-dark', 'href' => '#', 'role' => 'button', 'data-bs-toggle' => 'dropdown', 'aria-expanded' => 'false'])
            . '<i class="fas fa-user-circle me-1"></i>' . Yii::$app->user->identity->fio
            . Html::endTag('a')
            . '<ul class="dropdown-menu">'
            . '<li>'
            . Html::beginForm(['/site/logout'], 'post', ['class' => 'd-inline'])
            . Html::submitButton(
                '<i class="fas fa-sign-out-alt me-2"></i>Выйти',
                ['class' => 'dropdown-item text-danger']
            )
            . Html::endForm()
            . '</li>'
            . '</ul>'
            . '</li>';
    }

    echo '<div class="d-flex justify-content-between w-100 align-items-center">';


    echo Nav::widget([
        'options' => ['class' => 'navbar-nav mx-auto'],
        'items' => $centerItems,
    ]);


    echo Nav::widget([
        'options' => ['class' => 'navbar-nav align-items-center'],
        'items' => $rightItems,
    ]);

    echo '</div>';

    NavBar::end();
    ?>


    <main id="main" class="flex-shrink-0" role="main" style="padding-top: 80px;">
        <div class="container-fluid px-4">
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <?= Breadcrumbs::widget([
                    'links' => $this->params['breadcrumbs'],
                    'options' => ['class' => 'breadcrumb bg-light rounded py-2 px-3 mt-3'],
                    'itemTemplate' => '<li class="breadcrumb-item">{link}</li>',
                    'activeItemTemplate' => '<li class="breadcrumb-item active">{link}</li>'
                ]) ?>
            <?php endif ?>
            <?= Alert::widget() ?>
            <?= $content ?>
        </div>
    </main>

    <footer id="footer" class="mt-auto py-4 bg-dark text-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6 text-center text-md-start">
                    <p class="mb-0">&copy; Отель "Как дома" <?= date('Y') ?></p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <p class="mb-0">
                        <i class="fas fa-heart text-danger me-1"></i>Создано с заботой о вашем комфорте
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>