<?php
use yii\widgets\ActiveForm;
use yii\helpers\Html;
?>

<div class="booking-container">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10">
            <div class="booking-card card border-0 shadow-lg rounded-3 overflow-hidden">
                <div class="card-header bg-primary text-white py-4">
                    <div class="d-flex align-items-center">
                        <div class="booking-icon bg-white bg-opacity-20 rounded-circle p-3 me-3">
                            <i class="fas fa-calendar-plus fa-2x"></i>
                        </div>
                        <div>
                            <h1 class="h3 fw-bold mb-1">Создать бронирование</h1>
                            <p class="mb-0 opacity-75">Заполните форму для бронирования номера</p>
                        </div>
                    </div>
                </div>

                <div class="card-body p-5">
                    <?php $form = ActiveForm::begin([
                        'options' => ['class' => 'booking-form'],
                        'fieldConfig' => [
                            'options' => ['class' => 'form-group mb-4'],
                            'template' => "{label}\n{input}\n{error}",
                            'errorOptions' => ['class' => 'invalid-feedback'],
                            'labelOptions' => ['class' => 'form-label fw-semibold text-dark mb-3']
                        ]
                    ]); ?>

                    <!-- Выбор номера -->
                    <div class="form-floating mb-4">
                        <?= $form->field($model, 'room_id')->dropDownList(
                            \yii\helpers\ArrayHelper::map($rooms,'id','name'),
                            [
                                'class' => 'form-select form-select-lg py-3',
                                'prompt' => 'Выберите номер...'
                            ]
                        )->label('<i class="fas fa-bed me-2"></i>Выбор номера') ?>
                    </div>

                    <!-- Даты заезда и выезда -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <?= $form->field($model, 'checkin')->input('date', [
                                    'class' => 'form-control form-control-lg py-3'
                                ])->label('<i class="fas fa-sign-in-alt me-2"></i>Дата заезда') ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <?= $form->field($model, 'checkout')->input('date', [
                                    'class' => 'form-control form-control-lg py-3'
                                ])->label('<i class="fas fa-sign-out-alt me-2"></i>Дата выезда') ?>
                            </div>
                        </div>
                    </div>

                    <!-- Количество гостей -->
                    <div class="form-floating mb-4">
                        <?= $form->field($model, 'guests')->input('number', [
                            'class' => 'form-control form-control-lg py-3',
                            'min' => '1',
                            'max' => '10',
                            'placeholder' => ' '
                        ])->label('<i class="fas fa-users me-2"></i>Количество гостей') ?>
                    </div>

                    <!-- Дополнительные услуги -->
                    <div class="mb-4">
                        <?= $form->field($model, 'additional_services')->textarea([
                            'class' => 'form-control form-control-lg py-3',
                            'rows' => 4,
                            'placeholder' => 'Укажите дополнительные пожелания или услуги...'
                        ])->label('<i class="fas fa-concierge-bell me-2"></i>Дополнительные услуги') ?>
                        <div class="form-text">Например: завтрак в номер, трансфер, экскурсии и т.д.</div>
                    </div>

                    <!-- Способ оплаты -->
                    <div class="mb-4">
                        <label class="form-label fw-semibold text-dark mb-3">
                            <i class="fas fa-credit-card me-2"></i>Способ оплаты
                        </label>
                        <div class="payment-methods">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="payment-option">
                                        <?= $form->field($model, 'payment_type', [
                                            'template' => '{input} {label}',
                                            'options' => ['class' => 'form-check']
                                        ])->radio([
                                            'value' => 'Наличные',
                                            'class' => 'form-check-input',
                                            'label' => false
                                        ], false)->label(
                                            '<div class="payment-card bg-warning bg-opacity-10 rounded-3 p-4 text-center h-100">
                                                <i class="fas fa-money-bill-wave fa-2x text-warning mb-3"></i>
                                                <div class="fw-semibold text-dark">Наличные</div>
                                                <small class="text-muted">Оплата при заселении</small>
                                            </div>',
                                            ['class' => 'form-check-label stretched-link']
                                        ) ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="payment-option">
                                        <?= $form->field($model, 'payment_type', [
                                            'template' => '{input} {label}',
                                            'options' => ['class' => 'form-check']
                                        ])->radio([
                                            'value' => 'Карта',
                                            'class' => 'form-check-input',
                                            'label' => false
                                        ], false)->label(
                                            '<div class="payment-card bg-info bg-opacity-10 rounded-3 p-4 text-center h-100">
                                                <i class="fas fa-credit-card fa-2x text-info mb-3"></i>
                                                <div class="fw-semibold text-dark">Карта</div>
                                                <small class="text-muted">Онлайн оплата</small>
                                            </div>',
                                            ['class' => 'form-check-label stretched-link']
                                        ) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Кнопка отправки -->
                    <div class="form-group mt-5">
                        <?= Html::submitButton('<i class="fas fa-calendar-check me-2"></i>Забронировать номер', [
                            'class' => 'btn btn-success btn-lg w-100 py-3 fw-bold fs-5'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>

                <!-- Дополнительная информация -->
                <div class="card-footer bg-light border-0 py-4">
                    <div class="row text-center">
                        <div class="col-md-4 mb-3 mb-md-0">
                            <div class="d-flex align-items-center justify-content-center">
                                <i class="fas fa-shield-alt text-success me-2"></i>
                                <small class="text-muted">Безопасное бронирование</small>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3 mb-md-0">
                            <div class="d-flex align-items-center justify-content-center">
                                <i class="fas fa-clock text-success me-2"></i>
                                <small class="text-muted">Подтверждение за 5 минут</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex align-items-center justify-content-center">
                                <i class="fas fa-phone text-success me-2"></i>
                                <small class="text-muted">Поддержка 24/7</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Дополнительные стили -->
<style>
    .booking-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        padding: 2rem 0;
    }

    .booking-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
    }

    .form-control, .form-select {
        border: 2px solid #e9ecef;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .form-control:focus, .form-select:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }

    .form-check-input {
        display: none;
    }

    .form-check-input:checked + .form-check-label .payment-card {
        border: 2px solid #667eea;
        background: rgba(102, 126, 234, 0.1) !important;
    }

    .payment-card {
        border: 2px solid transparent;
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .payment-card:hover {
        border-color: #667eea;
        transform: translateY(-2px);
    }

    .btn-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        border: none;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(40, 167, 69, 0.4);
    }

    .booking-icon {
        transition: transform 0.3s ease;
    }

    .booking-card:hover .booking-icon {
        transform: scale(1.1);
    }

    /* Стили для радиокнопок оплаты */
    .payment-option {
        position: relative;
    }

    .form-check-input:checked + .form-check-label::before {
        content: '✓';
        position: absolute;
        top: 10px;
        right: 10px;
        background: #28a745;
        color: white;
        width: 24px;
        height: 24px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        font-weight: bold;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .booking-card .card-body {
            padding: 2rem 1.5rem;
        }

        .form-control-lg, .form-select-lg {
            font-size: 1rem;
            padding: 1rem 1.25rem;
        }

        .payment-methods .row.g-3 .col-md-6 {
            margin-bottom: 1rem;
        }
    }

    /* Анимация появления */
    .booking-card {
        animation: slideUp 0.5s ease-out;
    }

    @keyframes slideUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>