<?php
use yii\helpers\Html;

$this->title = 'Панель администратора';
?>

<div class="admin-container">
    <div class="row">
        <div class="col-12">
            <!-- Заголовок -->
            <div class="admin-header mb-5">
                <div class="d-flex align-items-center mb-4">
                    <div class="admin-icon bg-primary bg-opacity-10 rounded-circle p-3 me-4">
                        <i class="fas fa-cog fa-2x text-primary"></i>
                    </div>
                    <div>
                        <h1 class="h2 fw-bold text-dark mb-2"><?= Html::encode($this->title) ?></h1>
                        <p class="text-muted mb-0">Управление бронированиями и статусами заказов</p>
                    </div>
                </div>

                <!-- Статистика -->
                <div class="row g-3 mb-4">
                    <div class="col-xl-3 col-md-6">
                        <div class="stat-card bg-primary bg-opacity-10 rounded-3 p-4">
                            <div class="d-flex align-items-center">
                                <div class="stat-icon bg-primary rounded-circle p-3 me-3">
                                    <i class="fas fa-list-alt text-white"></i>
                                </div>
                                <div>
                                    <h3 class="h4 fw-bold mb-0"><?= count($bookings) ?></h3>
                                    <p class="text-muted mb-0 small">Всего броней</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6">
                        <div class="stat-card bg-warning bg-opacity-10 rounded-3 p-4">
                            <div class="d-flex align-items-center">
                                <div class="stat-icon bg-warning rounded-circle p-3 me-3">
                                    <i class="fas fa-clock text-white"></i>
                                </div>
                                <div>
                                    <h3 class="h4 fw-bold mb-0"><?= count(array_filter($bookings, function($b) { return $b->status === 'В процессе'; })) ?></h3>
                                    <p class="text-muted mb-0 small">В процессе</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6">
                        <div class="stat-card bg-success bg-opacity-10 rounded-3 p-4">
                            <div class="d-flex align-items-center">
                                <div class="stat-icon bg-success rounded-circle p-3 me-3">
                                    <i class="fas fa-check text-white"></i>
                                </div>
                                <div>
                                    <h3 class="h4 fw-bold mb-0"><?= count(array_filter($bookings, function($b) { return $b->status === 'Выполнено'; })) ?></h3>
                                    <p class="text-muted mb-0 small">Выполнено</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6">
                        <div class="stat-card bg-info bg-opacity-10 rounded-3 p-4">
                            <div class="d-flex align-items-center">
                                <div class="stat-icon bg-info rounded-circle p-3 me-3">
                                    <i class="fas fa-users text-white"></i>
                                </div>
                                <div>
                                    <h3 class="h4 fw-bold mb-0"><?= count(array_unique(array_column($bookings, 'user_id'))) ?></h3>
                                    <p class="text-muted mb-0 small">Уникальных клиентов</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Таблица бронирований -->
            <div class="admin-table-card card border-0 shadow-sm rounded-3">
                <div class="card-header bg-transparent border-0 py-4">
                    <h3 class="h5 fw-bold mb-0 text-dark">
                        <i class="fas fa-calendar-alt me-2 text-primary"></i>
                        Список бронирований
                    </h3>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="table-light">
                            <tr>
                                <th class="ps-4 py-3 fw-semibold text-muted small text-uppercase border-0">ID</th>
                                <th class="py-3 fw-semibold text-muted small text-uppercase border-0">Пользователь</th>
                                <th class="py-3 fw-semibold text-muted small text-uppercase border-0">Номер</th>
                                <th class="py-3 fw-semibold text-muted small text-uppercase border-0">Дата заезда</th>
                                <th class="py-3 fw-semibold text-muted small text-uppercase border-0">Дата выезда</th>
                                <th class="py-3 fw-semibold text-muted small text-uppercase border-0">Гостей</th>
                                <th class="py-3 fw-semibold text-muted small text-uppercase border-0">Статус</th>
                                <th class="pe-4 py-3 fw-semibold text-muted small text-uppercase border-0 text-end">Действие</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach($bookings as $booking): ?>
                                <tr class="border-top">
                                    <td class="ps-4 py-3 fw-bold text-dark">#<?= $booking->id ?></td>
                                    <td class="py-3">
                                        <div class="d-flex align-items-center">
                                            <div class="user-avatar bg-primary bg-opacity-10 rounded-circle me-3 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                <i class="fas fa-user text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="fw-medium text-dark"><?= $booking->user->fio ?></div>
                                                <small class="text-muted">ID: <?= $booking->user->id ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-3">
                                            <span class="badge bg-primary bg-opacity-10 text-primary fs-6 py-2 px-3 rounded">
                                                <?= $booking->room->name ?>
                                            </span>
                                    </td>
                                    <td class="py-3">
                                        <div class="fw-medium text-dark"><?= date('d.m.Y', strtotime($booking->checkin)) ?></div>
                                        <small class="text-muted"><?= date('H:i', strtotime($booking->checkin)) ?></small>
                                    </td>
                                    <td class="py-3">
                                        <div class="fw-medium text-dark"><?= date('d.m.Y', strtotime($booking->checkout)) ?></div>
                                        <small class="text-muted"><?= date('H:i', strtotime($booking->checkout)) ?></small>
                                    </td>
                                    <td class="py-3">
                                            <span class="badge bg-secondary bg-opacity-10 text-secondary fs-6 py-2 px-3 rounded">
                                                <i class="fas fa-user-friends me-1"></i><?= $booking->guests ?>
                                            </span>
                                    </td>
                                    <td class="py-3">
                                        <?php
                                        $statusClass = [
                                            'В процессе' => 'bg-warning text-dark',
                                            'Выполнено' => 'bg-success text-white',
                                            'Новый' => 'bg-info text-white'
                                        ][$booking->status] ?? 'bg-secondary text-white';
                                        ?>
                                        <span class="badge <?= $statusClass ?> fs-6 py-2 px-3 rounded-pill">
                                                <?= $booking->status ?>
                                            </span>
                                    </td>
                                    <td class="pe-4 py-3 text-end">
                                        <div class="btn-group" role="group">
                                            <?= Html::a('<i class="fas fa-cog me-1"></i>Подбираем номер',
                                                ['update-status','id'=>$booking->id,'status'=>'В процессе'],
                                                ['class'=>'btn btn-sm btn-outline-warning rounded-start-pill px-3']) ?>
                                            <?= Html::a('<i class="fas fa-check me-1"></i>Принято',
                                                ['update-status','id'=>$booking->id,'status'=>'Выполнено'],
                                                ['class'=>'btn btn-sm btn-outline-success rounded-end-pill px-3']) ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Пустая state -->
            <?php if(empty($bookings)): ?>
                <div class="text-center py-5">
                    <div class="empty-state-icon mb-4">
                        <i class="fas fa-calendar-times fa-4x text-muted opacity-25"></i>
                    </div>
                    <h4 class="text-muted mb-3">Бронирований пока нет</h4>
                    <p class="text-muted mb-4">Когда появятся новые бронирования, они отобразятся здесь</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Дополнительные стили -->
<style>
    .admin-container {
        background: #f8f9fa;
        min-height: 100vh;
        padding: 2rem 0;
    }

    .admin-table-card {
        background: #fff;
    }

    .table > :not(caption) > * > * {
        padding: 1rem 0.75rem;
    }

    .border-top {
        border-top: 1px solid #e9ecef !important;
    }

    .stat-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    .user-avatar {
        transition: transform 0.3s ease;
    }

    tr:hover .user-avatar {
        transform: scale(1.1);
    }

    .btn-group .btn {
        border-radius: 0;
    }

    .btn-group .btn:first-child {
        border-top-left-radius: 50rem !important;
        border-bottom-left-radius: 50rem !important;
    }

    .btn-group .btn:last-child {
        border-top-right-radius: 50rem !important;
        border-bottom-right-radius: 50rem !important;
    }

    .table-hover tbody tr:hover {
        background-color: rgba(0, 123, 255, 0.04);
    }

    .badge {
        font-weight: 500;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .admin-header .d-flex {
            flex-direction: column;
            text-align: center;
        }

        .admin-icon {
            margin: 0 auto 1rem auto !important;
        }

        .table-responsive {
            font-size: 0.875rem;
        }

        .btn-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }

        .btn-group .btn {
            border-radius: 50rem !important;
        }
    }
</style>