<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\User;
use app\models\Room;
use app\models\Booking;
use yii\web\NotFoundHttpException;

class SiteController extends Controller
{
    public function actionIndex()
    {
        $rooms = Room::find()->limit(3)->all();
        return $this->render('index', ['rooms' => $rooms]);
    }

    public function actionRooms()
    {
        $rooms = Room::find()->all();
        return $this->render('rooms', ['rooms' => $rooms]);
    }

    public function actionRegister()
    {
        $model = new User();

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Регистрация прошла успешно!');
                return $this->redirect(['site/login']);
            }
        }

        return $this->render('register', ['model'=>$model]);
    }

    public function actionLogin()
    {
        $model = new \yii\base\DynamicModel(['email','password']);
        $model->addRule(['email','password'], 'required');
        $model->addRule('email', 'email');

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            $user = User::findByEmail($model->email);
            if ($user && $user->validatePassword($model->password)) {
                Yii::$app->user->login($user);
                if ($user->is_admin) {
                    return $this->redirect(['admin/index']);
                }
                return $this->goHome();
            } else {
                $model->addError('password', 'Неверный email или пароль');
            }
        }

        return $this->render('login', ['model'=>$model]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }
}
