<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Booking;

class AdminController extends Controller
{
    public function behaviors()
    {
        return [
            'access'=>[
                'class'=>AccessControl::class,
                'only'=>['index','update-status'],
                'rules'=>[
                    [
                        'allow'=>true,
                        'roles'=>['@'],
                        'matchCallback'=>function($rule,$action){
                            return Yii::$app->user->identity->is_admin == 1;
                        }
                    ]
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $bookings = Booking::find()->all();
        return $this->render('index', ['bookings'=>$bookings]);
    }

    public function actionUpdateStatus($id, $status)
    {
        $booking = Booking::findOne($id);
        if ($booking) {
            $booking->status = $status;
            $booking->save();
        }
        return $this->redirect(['index']);
    }
}
